

PROCEDURE SETPARTRED(
       M,N                :INTEGER;
   VAR MR,NR              :INTEGER;
   VAR A                  :ARRMN;
   VAR SETS               :SETFAMILY;
   VAR SETLISTS           :INDEXSET;
   VAR C                  :ARRN;
   VAR NONFEASIBLE,OPTIMAL:BOOLEAN;
   VAR ELCOVER            :ARRM;
   VAR COVER              :ARRN;
   VAR COST               :INTEGER);

   VAR I,J                  :INTEGER;
       BR2,BR3R,BR5,CONTINUE:BOOLEAN;
       NSL                  :ARRM;
       NS                   :ARRN;

   FUNCTION MN:BOOLEAN;
   BEGIN               { MN IS TRUE IF THE PROBLEM HAS NOT VANISHED }
      MN:=(MR > 0) AND (NR > 0)
   END;  { MN }

   PROCEDURE EMPTYSET;
      VAR I:INTEGER;
   BEGIN                              { EMPTYSET REMOVES EMPTY SETS }
      FOR I:=1 TO N DO
         IF (COVER[I] = -1) AND (NS[I] = 0) THEN BEGIN
            NR:=NR-1;  COVER[I]:=0
      END
   END;  { EMPTY SET }

   FUNCTION EMPTYLIST:BOOLEAN;
      { EMPTYLIST IS TRUE IF IN THE CURRENT PROBLEM SOME
        ELEMENT CANNOT BE COVERED BY ANY SET }
      VAR I:INTEGER;
          B:BOOLEAN;
   BEGIN
      B:=FALSE;  I:=1;
      WHILE NOT B AND (I <= M) DO BEGIN
         B:=(NSL[I] = 0) AND (ELCOVER[I] = 0);
         I:=I+1
      END;
      EMPTYLIST:=B
   END;  { EMPTY LIST }

   PROCEDURE DELETESET(VAR J,NR:INTEGER;VAR NSL:ARRM;VAR COVER:ARRN);
      VAR L:INTEGER;
          P:POINTEL;
   BEGIN             { THE PROCEDURE DELETES SET J FROM THE PROBLEM }
      NR:=NR-1;  COVER[J]:=0;
      P:=SETS[J].LIST;
      WHILE P <> NIL DO BEGIN
         L:=P^.ELEM;
         NSL[L]:=NSL[L]-1;
         P:=P^.NEXT
      END
   END;  { DELETE SET J }

   PROCEDURE SPRED2(VAR BR2:BOOLEAN);
      VAR I,K,L,T:INTEGER;
          P,Q    :POINTEL;
   BEGIN                         { REDUCTION 2 - ROWS WITH SINGLE 1 }
      BR2:=FALSE;
      FOR I:=1 TO M DO
         IF (ELCOVER[I] = 0) AND (NSL[I] = 1) THEN BEGIN
            BR2:=TRUE;  MR:=MR-1;
            ELCOVER[I]:=1;
            P:=SETLISTS[I].LIST;
            REPEAT
               T:=P^.ELEM;  P:=P^.NEXT
            UNTIL COVER[T] = -1;
            NR:=NR-1;
            COVER[T]:=1;  COST:=COST+C[T];
            P:=SETS[T].LIST;
            WHILE P <> NIL DO BEGIN
               L:=P^.ELEM;
               IF ELCOVER[L] = 0 THEN BEGIN
                  MR:=MR-1;  ELCOVER[L]:=1;
                  Q:=SETLISTS[L].LIST;
                  WHILE Q <> NIL DO BEGIN
                     K:=Q^.ELEM;
                     IF COVER[K] = -1 THEN DELETESET(K,NR,NSL,COVER);
                     Q:=Q^.NEXT
                  END  { WHILE Q <> NIL }
               END;  { IF ELCOVER[L] = 0 }
               P:=P^.NEXT
            END  { WHILE P <> NIL }
         END  { IF (ELCOVER[I] = 0) ..., FOR I }
   END;  { SPRED2 }

   PROCEDURE SPRED3R(VAR BR3R:BOOLEAN);
      VAR H,I,J,K,L:INTEGER;
          B        :BOOLEAN;
   BEGIN                           { REDUCTION 3R - DOMINATING ROWS }
      BR3R:=FALSE;
      FOR I:=1 TO M-1 DO
         IF ELCOVER[I] = 0 THEN BEGIN
            J:=I;
            REPEAT  { UNTIL (J = M) ... }
               J:=J+1;  L:=0;
               IF ELCOVER[J] = 0 THEN BEGIN
                  IF NSL[I] <= NSL[J] THEN BEGIN
                     K:=I;  L:=J
                  END
                  ELSE BEGIN K:=J;  L:=I END;
                  H:=1;  B:=TRUE;
                  WHILE (H <= N) AND B DO BEGIN
                     IF COVER[H] = -1 THEN B:=A[L,H] >= A[K,H];
                     H:=H+1
                  END;
                  IF B THEN BEGIN            { ROW L CAN BE DELETED }
                     BR3R:=TRUE;  MR:=MR-1;
                     ELCOVER[L]:=1;
                     FOR H:=1 TO N DO
                        IF COVER[H] = -1 THEN
                           IF A[L,H] = 1 THEN BEGIN
                              NS[H]:=NS[H]-1;
                              IF A[K,H] = 0 THEN
                                 DELETESET(H,NR,NSL,COVER)
                           END  { IF A[L,H] = 1 }
                  END { IF B }
               END  { IF ELCOVER[J] = 0 }
            UNTIL  (J = M) OR ( B AND (L = I))
         END  { IF ELCOVER[I] = 0, FOR I }
   END;  { SPRED3R }

   PROCEDURE SPRED3C;
      VAR H,I,J,K,L:INTEGER;
          B        :BOOLEAN;
   BEGIN                   { REDUCTION 3C - COST DOMINATING COLUMNS }
      FOR J:=1 TO N-1 DO
         IF COVER[J] = -1 THEN BEGIN
            I:=J;
            REPEAT  { UNTIL (I = N) ... }
               I:=I+1;  L:=0;
               IF COVER[I] = -1 THEN BEGIN
                  IF C[J] <= C[I] THEN BEGIN K:=J;  L:=I END
                  ELSE BEGIN K:=I;  L:=J END;
                  H:=1;  B:=TRUE;
                  WHILE  (H <= M) AND B DO BEGIN
                     IF ELCOVER[H] = 0 THEN B:=A[H,K] = A[H,L];
                     H:=H+1
                  END;
                  IF B THEN  DELETESET(L,NR,NSL,COVER)
               END  { IF COVER[I] = -1 }
            UNTIL (I = N) OR (B AND (L = J))
         END  { IF COVER[J] = -1, FOR J }
   END;  { SPRED3C }

   PROCEDURE SPRED5(VAR BR5:BOOLEAN);
      { REDUCTION 5 - INFEASIBLE COLUMNS }
      VAR J:INTEGER;

      FUNCTION REMOVE(T,NRR:INTEGER;NL:ARRM;COV:ARRN):BOOLEAN;
         { REMOVE IS TRUE IF SET T CAN BE REMOVED SINCE ITS
           PRESENCE IN THE SOLUTION WOULD CAUSE INFEASIBILITY }
         VAR I,J:INTEGER;
             B  :BOOLEAN;
             P,Q:POINTEL;
     BEGIN
         COV[T]:=1;  P:=SETS[T].LIST;
         WHILE (P <> NIL) AND (NRR > 0) DO BEGIN
            I:=P^.ELEM;  Q:=SETLISTS[I].LIST;
            WHILE (Q <> NIL) AND (NRR > 0) DO BEGIN
               J:=Q^.ELEM;
               IF COV[J] = -1 THEN DELETESET(J,NRR,NL,COV);
               Q:=Q^.NEXT
            END;
            P:=P^.NEXT
         END;  { WHILE (P <> NIL) ... }
         B:=TRUE;  I:=1;
         WHILE (I <= M) AND B DO BEGIN
            B:=(ELCOVER[I] = 1) OR (NL[I] > 0);
            I:=I+1
         END;
         REMOVE:=NOT B
      END;  { REMOVE }
   BEGIN                                           { BODY OF SPRED5 }
      BR5:=FALSE;
      FOR J:=1 TO N DO
         IF COVER[J] = -1 THEN
            IF REMOVE(J,NR,NSL,COVER) THEN BEGIN
               BR5:=TRUE;
               DELETESET(J,NR,NSL,COVER)
            END
   END;  { SPRED5 }

BEGIN                                                   { MAIN BODY }
   COST:=0;
   FOR I:=1 TO M DO BEGIN
      ELCOVER[I]:=0;  NSL[I]:=SETLISTS[I].CARD
   END;
   FOR J:=1 TO N DO BEGIN
      COVER[J]:=-1;  NS[J]:=SETS[J].CARD
   END;
   MR:=M;  NR:=N;
   NONFEASIBLE:=FALSE;  OPTIMAL:=FALSE;
   IF EMPTYLIST THEN NONFEASIBLE:=TRUE
   ELSE BEGIN
      EMPTYSET;
      SPRED3C;
      REPEAT  { UNTIL NOT ((BR2 OR ... }
         BR2:=FALSE;  BR3R:=FALSE;
         BR5:=FALSE;  CONTINUE:=TRUE;
         SPRED2(BR2);
         IF BR2 THEN CONTINUE:=MN AND NOT EMPTYLIST;
         IF CONTINUE THEN BEGIN
            SPRED3R(BR3R);
            IF BR3R THEN CONTINUE:=MN AND NOT EMPTYLIST;
            IF CONTINUE THEN BEGIN
               SPRED5(BR5);
               IF BR5 THEN CONTINUE:=MN AND NOT EMPTYLIST
            END
         END  { IF CONTINUE }
      UNTIL NOT ((BR2 OR BR3R OR BR5) AND CONTINUE);
      IF NOT CONTINUE THEN
         IF MR = 0 THEN BEGIN
            OPTIMAL:=TRUE;
            FOR J:=1 TO N DO
               IF COVER[J] = -1 THEN COVER[J]:=0
         END
         ELSE NONFEASIBLE:=TRUE
   END  { ELSE: NOT EMPTYLIST }
END;  { SETPARTRED }

